/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.debug.core.internal.model;

import com.aptana.js.debug.core.internal.model.JSDebugElement;
import com.aptana.js.debug.core.model.IJSScriptElement;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.debug.core.model.IDebugTarget;

public class JSDebugScriptElement
extends JSDebugElement
implements IJSScriptElement {
    private static final IJSScriptElement[] EMPTY = new IJSScriptElement[0];
    private IJSScriptElement parent;
    private String name;
    private final int baseLine;
    private final int lineExtent;
    private List<IJSScriptElement> children = new ArrayList<IJSScriptElement>();

    public JSDebugScriptElement(IDebugTarget target, String name, int baseLine, int lineExtent) {
        super(target);
        this.name = name;
        this.baseLine = baseLine;
        this.lineExtent = lineExtent;
    }

    public String getName() {
        return this.name;
    }

    public URI getLocation() {
        return this.getParent().getLocation();
    }

    public IJSScriptElement[] getChildren() {
        if (this.children.size() > 0) {
            return this.children.toArray(new IJSScriptElement[this.children.size()]);
        }
        return EMPTY;
    }

    public IJSScriptElement getParent() {
        return this.parent;
    }

    public int getBaseLine() {
        return this.baseLine;
    }

    public int getLineExtent() {
        return this.lineExtent;
    }

    void insertElement(JSDebugScriptElement scriptElement) {
        for (IJSScriptElement i : this.children) {
            JSDebugScriptElement element = (JSDebugScriptElement)i;
            if (element.isScriptElementInside(scriptElement)) {
                element.insertElement(scriptElement);
                return;
            }
            if (!scriptElement.isScriptElementInside(element)) continue;
            this.children.remove(element);
            scriptElement.insertElement(element);
            break;
        }
        this.children.add(scriptElement);
        scriptElement.setParent(this);
    }

    void removeElement(JSDebugScriptElement scriptElement) {
    }

    boolean isScriptElementInside(JSDebugScriptElement element) {
        return this.baseLine < element.getBaseLine() && element.getBaseLine() + element.getLineExtent() <= this.baseLine + this.lineExtent;
    }

    void setParent(IJSScriptElement parent) {
        this.parent = parent;
    }

    void setName(String name) {
        this.name = name;
    }
}

